/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.client.gui;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.montoyo.mcef.api.IBrowser;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.client.ClientProxy;
import net.montoyo.wd.client.gui.WDScreen;
import net.montoyo.wd.utilities.BlockSide;
import org.cef.browser.CefBrowserOsr;
import org.lwjgl.glfw.GLFW;

@OnlyIn(value=Dist.CLIENT)
public class GuiMinePad
extends WDScreen {
    private ClientProxy.PadData pad;
    private double vx;
    private double vy;
    private double vw;
    private double vh;

    public GuiMinePad() {
        super(Component.m_130674_(null));
    }

    public GuiMinePad(ClientProxy.PadData pad) {
        this();
        this.pad = pad;
        if (WebDisplays.cursorSupport) {
            pad.view.allowCursorChanges(true);
        }
    }

    @Override
    public void m_7856_() {
        this.vw = (double)this.f_96543_ - 32.0;
        this.vh = this.vw / 1.9666666666666666;
        this.vx = 16.0;
        this.vy = ((double)this.f_96544_ - this.vh) / 2.0;
        this.f_96543_ = (int)this.vw;
        this.f_96544_ = (int)this.vh;
        super.m_7856_();
    }

    private static void addRect(BufferBuilder bb, double x, double y, double w, double h) {
        bb.m_5483_(x, y, 0.0).m_6122_(255, 255, 255, 255).m_5752_();
        bb.m_5483_(x + w, y, 0.0).m_6122_(255, 255, 255, 255).m_5752_();
        bb.m_5483_(x + w, y + h, 0.0).m_6122_(255, 255, 255, 255).m_5752_();
        bb.m_5483_(x, y + h, 0.0).m_6122_(255, 255, 255, 255).m_5752_();
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float ptt) {
        this.m_7333_(poseStack);
        RenderSystem.m_69472_();
        RenderSystem.m_69464_();
        RenderSystem.m_157429_((float)0.73f, (float)0.73f, (float)0.73f, (float)1.0f);
        Tesselator t = Tesselator.m_85913_();
        BufferBuilder bb = t.m_85915_();
        bb.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        GuiMinePad.addRect(bb, this.vx, this.vy - 16.0, this.vw, 16.0);
        GuiMinePad.addRect(bb, this.vx, this.vy + this.vh, this.vw, 16.0);
        GuiMinePad.addRect(bb, this.vx - 16.0, this.vy, 16.0, this.vh);
        GuiMinePad.addRect(bb, this.vx + this.vw, this.vy, 16.0, this.vh);
        t.m_85914_();
        RenderSystem.m_69493_();
        if (this.pad.view != null) {
            this.pad.view.draw(poseStack, this.vx, this.vy + this.vh, this.vx + this.vw, this.vy);
        }
        RenderSystem.m_69481_();
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        return this.keyChanged(keyCode, scanCode, modifiers, true) || super.m_7933_(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        return this.keyChanged(keyCode, scanCode, modifiers, false) || super.m_7920_(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.pad.view != null) {
            this.pad.view.injectKeyTyped((int)codePoint, modifiers);
            return true;
        }
        return super.m_5534_(codePoint, modifiers);
    }

    public boolean keyChanged(int keyCode, int scanCode, int modifiers, boolean pressed) {
        assert (this.f_96541_ != null);
        if (keyCode == 256) {
            this.f_96541_.m_91152_(null);
            return true;
        }
        InputConstants.Key iuKey = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        String keystr = iuKey.m_84875_().getString();
        if (keystr.length() == 0) {
            return false;
        }
        char key = keystr.charAt(keystr.length() - 1);
        if (keystr.equals("Enter")) {
            keyCode = 10;
            key = '\n';
        }
        if (this.pad.view != null) {
            if (pressed) {
                this.pad.view.injectKeyPressedByKeyCode(keyCode, key, modifiers);
            } else {
                this.pad.view.injectKeyReleasedByKeyCode(keyCode, key, modifiers);
            }
            if (pressed && key == '\n' && modifiers != 0) {
                this.pad.view.injectKeyTyped(13, modifiers);
            }
            return true;
        }
        return false;
    }

    @Override
    public void m_94757_(double mouseX, double mouseY) {
        super.m_94757_(mouseX, mouseY);
        this.mouse(-1, false, (int)mouseX, (int)mouseY, 0.0);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.mouse(button, true, (int)mouseX, (int)mouseY, 0.0);
        return super.m_6375_(mouseX, mouseY, button);
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.mouse(button, false, (int)mouseX, (int)mouseY, 0.0);
        return super.m_6348_(mouseX, mouseY, button);
    }

    @Override
    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        this.mouse(button, true, (int)mouseX, (int)mouseY, 0.0);
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        this.mouse(-1, false, (int)mouseX, (int)mouseY, amount);
        return super.m_6050_(mouseX, mouseY, amount);
    }

    public void mouse(int btn, boolean pressed, int sx, int sy, double scrollAmount) {
        double mx = ((double)sx - this.vx) / this.vw;
        double my = ((double)sy - this.vy) / this.vh;
        if (this.pad.view != null && mx >= 0.0 && mx <= 1.0) {
            int wheel = (int)scrollAmount;
            sx = (int)(mx * WebDisplays.INSTANCE.padResX);
            sy = (int)(my * WebDisplays.INSTANCE.padResY);
            if (wheel != 0) {
                this.pad.view.injectMouseWheel(sx, sy, GuiMinePad.m_96637_() && !GuiMinePad.m_96639_() && !GuiMinePad.m_96638_() ? 2 : 0, wheel, 0);
            }
            if (btn == -1) {
                this.pad.view.injectMouseMove(sx, sy, 0, sy < 0);
            } else {
                this.pad.view.injectMouseButton(sx, sy, 0, btn + 1, pressed, 1);
            }
        }
    }

    public static Optional<Character> getChar(int keyCode, int scanCode) {
        String keystr = GLFW.glfwGetKeyName((int)keyCode, (int)scanCode);
        if (keystr == null) {
            keystr = "\u0000";
        }
        if (keyCode == 257) {
            keystr = "\n";
        }
        if (keystr.length() == 0) {
            return Optional.empty();
        }
        return Optional.of(Character.valueOf(keystr.charAt(keystr.length() - 1)));
    }

    @Override
    public void m_86600_() {
        if (this.pad.view == null) {
            this.f_96541_.m_91152_(null);
        }
    }

    @Override
    public boolean isForBlock(BlockPos bp, BlockSide side) {
        return false;
    }

    public void m_7861_() {
        super.m_7861_();
        IBrowser iBrowser = this.pad.view;
        if (iBrowser instanceof CefBrowserOsr) {
            CefBrowserOsr osr = (CefBrowserOsr)iBrowser;
            osr.allowCursorChanges(true);
            osr.onCursorChange(null, 0);
        }
    }

    @Override
    public void m_7379_() {
        super.m_7379_();
        if (WebDisplays.cursorSupport) {
            this.pad.view.allowCursorChanges(false);
            IBrowser iBrowser = this.pad.view;
            if (iBrowser instanceof CefBrowserOsr) {
                CefBrowserOsr osr = (CefBrowserOsr)iBrowser;
                osr.onCursorChange(null, 0);
            }
        }
    }
}

